// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     net/interfaces/proxy_resolver_service.mojom
//

package org.chromium.mojom.net.interfaces;

class ProxyResolverFactory_Internal {

    public static final org.chromium.mojo.bindings.Interface.Manager<ProxyResolverFactory, ProxyResolverFactory.Proxy> MANAGER =
            new org.chromium.mojo.bindings.Interface.Manager<ProxyResolverFactory, ProxyResolverFactory.Proxy>() {
    
        public String getName() {
            return "net::interfaces::ProxyResolverFactory";
        }
    
        public int getVersion() {
          return 0;
        }
    
        public Proxy buildProxy(org.chromium.mojo.system.Core core,
                                org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            return new Proxy(core, messageReceiver);
        }
    
        public Stub buildStub(org.chromium.mojo.system.Core core, ProxyResolverFactory impl) {
            return new Stub(core, impl);
        }
    
        public ProxyResolverFactory[] buildArray(int size) {
          return new ProxyResolverFactory[size];
        }
    };

    private static final int CREATE_RESOLVER_ORDINAL = 0;

    static final class Proxy extends org.chromium.mojo.bindings.Interface.AbstractProxy implements ProxyResolverFactory.Proxy {

        Proxy(org.chromium.mojo.system.Core core,
              org.chromium.mojo.bindings.MessageReceiverWithResponder messageReceiver) {
            super(core, messageReceiver);
        }

        @Override
        public void createResolver(String pacScript, org.chromium.mojo.bindings.InterfaceRequest<ProxyResolver> resolver, ProxyResolverFactoryRequestClient client) {
            ProxyResolverFactoryCreateResolverParams _message = new ProxyResolverFactoryCreateResolverParams();
            _message.pacScript = pacScript;
            _message.resolver = resolver;
            _message.client = client;
            getProxyHandler().getMessageReceiver().accept(
                    _message.serializeWithHeader(
                            getProxyHandler().getCore(),
                            new org.chromium.mojo.bindings.MessageHeader(CREATE_RESOLVER_ORDINAL)));
        }

    }

    static final class Stub extends org.chromium.mojo.bindings.Interface.Stub<ProxyResolverFactory> {

        Stub(org.chromium.mojo.system.Core core, ProxyResolverFactory impl) {
            super(core, impl);
        }

        @Override
        public boolean accept(org.chromium.mojo.bindings.Message message) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.NO_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_OR_CLOSE_PIPE_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRunOrClosePipe(
                                ProxyResolverFactory_Internal.MANAGER, messageWithHeader);
                    case CREATE_RESOLVER_ORDINAL: {
                        ProxyResolverFactoryCreateResolverParams data =
                                ProxyResolverFactoryCreateResolverParams.deserialize(messageWithHeader.getPayload());
                        getImpl().createResolver(data.pacScript, data.resolver, data.client);
                        return true;
                    }
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }

        @Override
        public boolean acceptWithResponder(org.chromium.mojo.bindings.Message message, org.chromium.mojo.bindings.MessageReceiver receiver) {
            try {
                org.chromium.mojo.bindings.ServiceMessage messageWithHeader =
                        message.asServiceMessage();
                org.chromium.mojo.bindings.MessageHeader header = messageWithHeader.getHeader();
                if (!header.validateHeader(org.chromium.mojo.bindings.MessageHeader.MESSAGE_EXPECTS_RESPONSE_FLAG)) {
                    return false;
                }
                switch(header.getType()) {
                    case org.chromium.mojo.bindings.InterfaceControlMessagesConstants.RUN_MESSAGE_ID:
                        return org.chromium.mojo.bindings.InterfaceControlMessagesHelper.handleRun(
                                getCore(), ProxyResolverFactory_Internal.MANAGER, messageWithHeader, receiver);
                    default:
                        return false;
                }
            } catch (org.chromium.mojo.bindings.DeserializationException e) {
                System.err.println(e.toString());
                return false;
            }
        }
    }

    static final class ProxyResolverFactoryCreateResolverParams extends org.chromium.mojo.bindings.Struct {
    
        private static final int STRUCT_SIZE = 32;
        private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(32, 0)};
        private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];
    
        public String pacScript;
        public org.chromium.mojo.bindings.InterfaceRequest<ProxyResolver> resolver;
        public ProxyResolverFactoryRequestClient client;
    
        private ProxyResolverFactoryCreateResolverParams(int version) {
            super(STRUCT_SIZE, version);
        }
    
        public ProxyResolverFactoryCreateResolverParams() {
            this(0);
        }
    
        public static ProxyResolverFactoryCreateResolverParams deserialize(org.chromium.mojo.bindings.Message message) {
            return decode(new org.chromium.mojo.bindings.Decoder(message));
        }
    
        @SuppressWarnings("unchecked")
        public static ProxyResolverFactoryCreateResolverParams decode(org.chromium.mojo.bindings.Decoder decoder0) {
            if (decoder0 == null) {
                return null;
            }
            org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
            ProxyResolverFactoryCreateResolverParams result = new ProxyResolverFactoryCreateResolverParams(mainDataHeader.elementsOrVersion);
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.pacScript = decoder0.readString(8, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.resolver = decoder0.readInterfaceRequest(16, false);
            }
            if (mainDataHeader.elementsOrVersion >= 0) {
                result.client = decoder0.readServiceInterface(20, false, ProxyResolverFactoryRequestClient.MANAGER);
            }
            return result;
        }
    
        @SuppressWarnings("unchecked")
        @Override
        protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
            org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
            encoder0.encode(pacScript, 8, false);
            encoder0.encode(resolver, 16, false);
            encoder0.encode(client, 20, false, ProxyResolverFactoryRequestClient.MANAGER);
        }
    
        /**
         * @see Object#equals(Object)
         */
        @Override
        public boolean equals(Object object) {
            if (object == this)
                return true;
            if (object == null)
                return false;
            if (getClass() != object.getClass())
                return false;
            ProxyResolverFactoryCreateResolverParams other = (ProxyResolverFactoryCreateResolverParams) object;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.pacScript, other.pacScript))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.resolver, other.resolver))
                return false;
            if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.client, other.client))
                return false;
            return true;
        }
    
        /**
         * @see Object#hashCode()
         */
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = prime + getClass().hashCode();
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(pacScript);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(resolver);
            result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(client);
            return result;
        }
    }

}

